	function h = IDEAL_IMPULSE_BP_Z(Wc1T, Wc2T, N)
 
	% 	Computes impulse response of an ideal digital bandpass FIR filter
	% 	with cutoff angles Wc1T and Wc2T. The length of the impulse response is N.
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2008-07-12
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	 
	%	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	M = (N-1)/2;
	for k = -M:M
		if k == 0
			h(k+M+1) = (Wc2T - Wc1T)/pi;
		else
			h(k+M+1) = sin(Wc2T*k)/(pi*k) - sin(Wc1T*k)/(pi*k);
		end
	end
